//@author: vux
//@help: template for standard shaders
//@tags: template
//@credits: Dx11 Litsphere Catweasel based on Misak's dx9 version

float normalPower <
	string UIName = "Bumpmap Strength";
	string UIWidget = "slider";
	float UIMin = 0.0;
	float UIMax = 2.0;
	float UIStep = 0.1;
> = 1.0;

bool flipGreen
<
    string UIName = "Invert Normal Map Green Channel?";
> = false;

struct particles
{
		float3 pos;
	float3 vel;
	float3 col;
	float size;
	
};

StructuredBuffer<particles> pData;

Texture2D normalMap <string uiname="normalMap";>;

SamplerState normalSampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};
Texture2D litSphereMap <string uiname="LitSphere";>;

SamplerState litSphereSampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};
 
cbuffer cbPerDraw : register( b0 )
{
	float4x4 tVP : VIEWPROJECTION;	
	float4x4 tWV            : WORLDVIEW;
	float4x4 tWVP  : WORLDVIEWPROJECTION;
};

cbuffer cbPerObj : register( b1 )
{
	float4x4 tW : WORLD;
	float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };
//	float4 Tangent  : TANGENT;
//	float4 Binormal : BINORMAL;
};

struct VS_IN
{
		uint ii : SV_InstanceID;
	float4 PosO : POSITION;
	float2 TexCd : TEXCOORD0;
	float3 Tangent  : TANGENT; //uncomment this line, save then bang the switch, sphere vanishes
	float3 Binormal : BINORMAL; //comment it out and save, its stays gone, bang switch it reappears
	float3 Normal   : NORMAL;

};

struct vs2ps
{
    float4 PosWVP: SV_POSITION;
    float2 TexCd: TEXCOORD0;
	float3 TexCoord1 : TEXCOORD1;
	float3 TexCoord2 : TEXCOORD2;
	float3 TexCoord3 : TEXCOORD3;
};

vs2ps VS(VS_IN input)
{
    vs2ps output = (vs2ps)0;
	
	// Pos to NDC
	float4 p = float4(pData[input.ii].pos,0); //particle Pos
	float3 c = pData[input.ii].col; //particle colour
	float4 pv = mul(input.PosO,tW); //Transform the model
    float4 PosV = pv + p; //Transform each instance to the particle position
//	output.PosWVP = mul(input.PosO, tWVP);
	output.PosWVP = mul(PosV, tVP);
	// Texcoords (for normal map)
    output.TexCd = input.TexCd;
	
		// Tangent space vectors
	float3 vtan = input.Tangent.xyz;
  float3 vbinorm = -input.Binormal.xyz;
	float3 vnorm =  input.Normal.xyz;
	output.TexCoord1.xyz = mul(float4(vtan,0),tWV).xyz;
	output.TexCoord2.xyz = mul(float4(vbinorm,0),tWV).xyz;
	output.TexCoord3.xyz = mul(float4(vnorm,0),tWV).xyz;
	
    return output;
}




float4 PS(vs2ps In): SV_Target
{

	float3 texNormal = normalMap.Sample(normalSampler,In.TexCd.xy).xyz;
	if(flipGreen)texNormal.g = 1-texNormal.g;
	texNormal.rgb = texNormal.rgb*2.0-1.0;
		// Fixes normals if no normal map texture is supplied
	if ( dot(texNormal,texNormal) > 2.0 ) {
		texNormal = float3(0,0,1);
	}
	
		// The normalizes can probably go away... but meh...
    float3 T = In.TexCoord1.xyz * normalPower;
    float3 B = In.TexCoord2.xyz * normalPower;
    float3 N = In.TexCoord3.xyz;

		// Put in world space and renormalize (after scaling)
    float3 worldNorm = normalize(N + texNormal.y * B + texNormal.x * T);
	// Swap it around a bit... 
	worldNorm.y = - worldNorm.y;
	
//   float3 light = litSphereMap.Sample(litSphereSampler,In.TexCd.xy).xyz;
 float3 light = litSphereMap.Sample(litSphereSampler,worldNorm.xy * 0.5 + 0.5).xyz;

	
	return float4( light, 1.0 );
}





technique10 Constant
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




